<?php

namespace Tests\Features;

use Orchestra\Testbench\Attributes\DefineEnvironment;
use Symfony\Component\Routing\Exception\RouteNotFoundException;
use Tests\TestCase;
use VelureLabs\VelureCms\Feature;

class FeaturesDisabledTest extends TestCase
{
    public function test_feature_is_disabled_by_default()
    {
        $this->assertFalse(Feature::Registration->enabled());
    }

    public function test_cannot_access_registration_page_when_disabled()
    {
        $this->assertThrows(function () {
            route('register');
        }, RouteNotFoundException::class);

        $response = $this->get('/register');

        $response->assertNotFound();
    }
}
