<?php

namespace Tests\Features;

use Orchestra\Testbench\Attributes\DefineEnvironment;
use Tests\TestCase;
use VelureLabs\VelureCms\Feature;

class RegistrationEnabledTest extends TestCase
{
    protected function defineEnvironment($app)
    {
        $app['config']->set('velure.features', [
            Feature::Registration,
        ]);
    }

    public function test_feature_can_be_enabled()
    {
        $this->assertTrue(Feature::Registration->enabled());
    }

    public function test_can_access_registration_page_when_enabled()
    {
        $response = $this->get(route('register'));

        $response->assertOk();
        $response->assertSeeText('Register!');
    }
}
