<?php

namespace VelureLabs\VelureCms;

use Illuminate\Http\Request;
use Illuminate\Support\Collection;

class GlobalSearch
{
    protected Searcher $search;
    protected int $pageLength = 10;

    public function __construct()
    {
        $this->search = new Searcher();
        $this->search->beginWithWildcard();
        $this->search->includeModelType();
    }

    public function registerModel($model, string|array $columns, ?string $orderBy = null): static
    {
        $this->search->add($model, $columns, $orderBy);

        return $this;
    }

    public function getModels(): Collection
    {
        return $this->search->getModels();
    }

    public function handleSearchRequest(Request $request, ?\Closure $transformer = null)
    {
        $data = $request->validate([
            'query' => 'required|string',
            'order-by' => 'sometimes|nullable|string|in:asc,desc',
        ]);

        $query = $this->search;

        if (isset($data['order-by'])) {
            $dir = ucfirst(strtolower($data['order-by']));
            $method = "orderBy{$dir}";

            $query->$method();
        }

        $results = $query
            ->paginate($this->pageLength)
            ->search($data['query']);

        if ($transformer) {
            $results->through($transformer);
        }

        return $results;
    }
}
