<?php

namespace VelureLabs\VelureCms;

use Illuminate\Support\ServiceProvider;

class VelureServiceProvider extends ServiceProvider
{
    public function register(): void
    {
        $this->app->singleton(Velure::class, function ($app) {
            return new Velure;
        });
        $this->app->singleton(GlobalSearch::class, function ($app) {
            return new GlobalSearch();
        });
    }

    public function boot(): void
    {
        $this->loadRoutesFrom(__DIR__.'/routes/web.php');
        $this->loadViewsFrom(__DIR__.'/resources/views', 'velure');
        $this->publishes([
            __DIR__.'/config/velure.php' => config_path('velure.php'),
        ]);
    }
}
