<?php

namespace App\Commands;

use Illuminate\Console\Scheduling\Schedule;
use LaravelZero\Framework\Commands\Command;

class NewCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'new {name : The directory the application will be created in.}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create a new Velure application';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $name = $this->argument('name');
        $path = getcwd().'/'.$name;

        $this->info("Creating new application $name...");

        shell_exec("composer create-project velure/velure:dev-main \"$path\" --repository-url=https://satis.robojuice.com");

        return self::SUCCESS;
    }

    /**
     * Define the command's schedule.
     */
    public function schedule(Schedule $schedule): void
    {
        // $schedule->command(static::class)->everyMinute();
    }
}
