import defaultTheme from 'tailwindcss/defaultTheme';
import typography from '@tailwindcss/typography';
import containerQueries from '@tailwindcss/container-queries';
import {brandColors} from './tailwind.custom.js';

/** @type {import('tailwindcss').Config} */
export default {
    content: [
        './vendor/laravel/framework/src/Illuminate/Pagination/resources/views/*.blade.php',
        './vendor/laravel/jetstream/**/*.blade.php',
        './storage/framework/views/*.php',
        './resources/views/**/*.blade.php',
        './resources/js/**/*.vue',
        './resources/js/**/*.js',
    ],

    theme: {
        extend: {
            fontFamily: {
                sans: ['Figtree', ...defaultTheme.fontFamily.sans],
            },
            colors: {
                ...brandColors
            },
            containers: {
                '4xs': '10rem',
                '3xs': '12rem',
                '2xs': '16rem',
            },
        },
    },

    plugins: [typography, containerQueries],
};
